import { ViewPropsBase, ViewStateBase, toOneWayRef } from '@ibiz-core';

/**
 * 视图基类
 */
export class ViewBase {
  /**
   * 视图状态
   */
  public viewState: ViewStateBase;

  /**
   * 构造方法，初始化状态
   * @param {*} options 配置参数
   */
  constructor(options: any) {
    this.viewState = reactive(options);
  }

  /**
   * 根据props调整设置部分视图基类
   * @param props 传入的Props
   */
   public setState(props: ViewPropsBase) {
    // todo 项目级配置入口，优先级大于平台，提供全局的一次性配置

    // 只读属性处理：把props的属性的Ref赋给state，以维持响应性。
    this.viewState.viewSubject = toRef(props, 'viewSubject') as any;
  }

  /**
   * 使用视图上下文参数逻辑块
   * @param props 传入的Props
   */
  public useViewContextParams(props: ViewPropsBase) {
    const context = toOneWayRef(props, 'context');
    const viewParams = toOneWayRef(props, 'viewParams');

    // 把Ref赋值到State上进行解包
    this.viewState.context = context;
    this.viewState.viewParams = viewParams;

    // 视图部分额外处理
    // todo 导航参数处理，自定义参数处理。
    // todo viewparams 视图级隔离，如果没有用导航参数这些指定，则把上一层的都消除。

    return { context, viewParams };
  }

  /**
   * 使用计数器服务模块
   * @todo
   * @param props
   */
  public useCounterService(props: ViewPropsBase){}

  /**
   * 安装视图所有功能模块的方法
   * @param props 传入的Props
   * @param [emit] 事件
   */
  public moduleInstall(props: ViewPropsBase, emit?: Function) {
    this.setState(props);
    this.useViewContextParams(props);
    this.useCounterService(props);
    return {
      state: this.viewState,
    };
  }
}
